<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class ServiceCategoryUpload extends Model 
{

    protected $table = 'service_category_uploads';
    public $timestamps = true;
    protected $fillable = array('user_id', 'service_category_id', 'filename', 'type', 'mime', 'extension', 'path');

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function serviceCategory()
    {
        return $this->belongsTo('App\Models\ServiceCategory', 'service_category_id');
    }

}